///////////////////
// Splash Screen //
///////////////////

#include "Splash Screen.h"

static const int SPLASHX = 295;
static const int SPLASHY = 270;

void SplashFrame::Create ()
{
    char name [256];
    int width, height;
    RECT rect;

    _MessageText [0] = NULL;
    _Bitmap.LoadBitmap (IDB_SPLASH);
    LoadString (IDS_LOADFONT, name);
    _Font.Create (BASE, name);

    _MessageBox.left = ANIMATEX;
    _MessageBox.right = SPLASHX - ANIMATEX;
    _MessageBox.bottom = SPLASHY;
    _MessageBox.top = SPLASHY - BASE;

    _AnimateBox.left = SPLASHX - ANIMATEX;
    _AnimateBox.right = SPLASHX;
    _AnimateBox.bottom = SPLASHY;
    _AnimateBox.top = SPLASHY - ANIMATEY;

    width = SPLASHX + (GetSystemMetrics (SM_CXDLGFRAME) * 2);
    height = SPLASHY + (GetSystemMetrics (SM_CYDLGFRAME) * 2);

    rect.left = (GetSystemMetrics (SM_CXSCREEN) - width) / 2;
    rect.top = (GetSystemMetrics (SM_CYSCREEN) - height) / 2;
    rect.right = rect.left + width;
    rect.bottom = rect.top + height;
    epp_Frame::Create (0, NULL, WS_POPUP | WS_DLGFRAME | WS_CLIPCHILDREN, rect);

    ShowWindow ();
    UpdateWindow ();
}

void SplashFrame::Message (const char *message)
{
    if (message)
        strcpy (_MessageText, message);
    else
        *_MessageText = NULL;

    InvalidateRect ();
}

int SplashFrame::OnCreate (CREATESTRUCT *)
{
    SetWindowText ("Dexter");
    _Animate.Create (IDB_SPIN, ANIFRAMES, ANISPEED, WS_VISIBLE, _AnimateBox, *this);
    return 0;
}

void SplashFrame::OnDestroy ()
{
    _Bitmap.Close ();
    _Font.Close ();
}

BOOL SplashFrame::OnEraseBkgnd (HDC)
{
    return TRUE;
}

void SplashFrame::OnPaint ()
{
    epp_PaintContext dc;
    epp_CustomContext bdc;

    dc.BeginPaint (*this);
    bdc.CreateCompatibleDC (dc);
    bdc.SelectObject (_Bitmap);
    dc.BitBlt (0, 0, SPLASHX, SPLASHY, bdc, 0, 0, SRCCOPY);

    if (*_MessageText) {
        dc.SetBkMode (TRANSPARENT);
        dc.SelectObject (_Font);
        dc.DrawText (_MessageText, -1, &_MessageBox, DT_CENTER | DT_VCENTER);
    }
}

BEGIN_HANDLER (SplashFrame, epp_Frame)
    ON_WM_PAINT
    ON_WM_ERASEBKGND
    ON_WM_CREATE
    ON_WM_DESTROY
END_HANDLER

SplashFrame Splash;